/*
 * Decompiled with CFR 0.152.
 */
import argumentation.ArgumentationFramework;
import argumentation.ArgumentationFrameworkLoader;
import argumentation.ArgumentationGamePlayer;
import argumentation.DefaultArgumentationFrameworkLoader;
import argumentation.GroundedGamePlayer;
import argumentation.PreferredGamePlayer;
import java.util.Scanner;

public class DiscussionGameHandler {
    private String[] args;
    private boolean[][] def;
    private Scanner input = new Scanner(System.in);
    private ArgumentationFramework af;
    private GroundedGamePlayer gp;
    private PreferredGamePlayer pp;
    private int gAnswer;
    private int pAnswer;
    private ArgumentationGamePlayer agp;
    private int currentGame;
    private boolean playingProponent;
    private int currentArg;
    private int previousArg;
    private String[] userOptions;
    private int[] optionsMap;
    private int questionCase;
    private DiscussionGameOutput out;
    private MessageGenerator mesGen;

    public void setOutput(DiscussionGameOutput discussionGameOutput) {
        this.out = discussionGameOutput;
    }

    public void setMessageGenerator(MessageGenerator messageGenerator) {
        this.mesGen = messageGenerator;
    }

    public void load(String string) {
        this.load(new DefaultArgumentationFrameworkLoader(string));
    }

    public void load(ArgumentationFrameworkLoader argumentationFrameworkLoader) {
        if (this.mesGen == null) {
            this.mesGen = new DefaultMessageGenerator(argumentationFrameworkLoader.getArgs());
        } else {
            this.mesGen.setArgs(argumentationFrameworkLoader.getArgs());
        }
        this.args = this.mesGen.getArgs();
        this.def = argumentationFrameworkLoader.getDef();
        this.af = new ArgumentationFramework(this.def);
        this.gp = new GroundedGamePlayer(this.def);
        this.pp = new PreferredGamePlayer(this.def);
        this.currentArg = -1;
        this.agp = null;
    }

    public String[] getArgs() {
        return this.args;
    }

    public ArgumentationFramework getExtensionManager() {
        return this.af;
    }

    public MessageGenerator getMessageGenerator() {
        return this.mesGen;
    }

    public String[] question(int n) {
        this.currentArg = n;
        this.gAnswer = 0;
        this.pAnswer = 0;
        this.questionCase = 0;
        String string = "";
        this.gp.init();
        this.gAnswer = this.gp.argue(n);
        if (this.gAnswer == -2) {
            string = this.mesGen.getMessage(-6, 0, n);
            this.questionCase = 1;
            this.userOptions = new String[2];
            this.userOptions[1] = this.mesGen.getMessage(-1, -10, true, n, 0);
        } else {
            this.pp.init();
            this.pAnswer = this.pp.argue(n);
            if (this.pAnswer == -2) {
                string = this.mesGen.getMessage(-7, 0, n);
                this.questionCase = 2;
                this.userOptions = new String[3];
                this.userOptions[1] = this.mesGen.getMessage(-1, -11, true, n, 0);
                this.userOptions[2] = this.mesGen.getMessage(-1, -10, false, n, 0);
            } else {
                string = this.mesGen.getMessage(-8, 0, n);
                this.questionCase = 3;
                this.userOptions = new String[2];
                this.userOptions[1] = this.mesGen.getMessage(-1, -11, false, n, 0);
            }
        }
        this.userOptions[0] = this.mesGen.getMessage(-12);
        this.out.output(string, 1);
        return this.userOptions;
    }

    public String[] startDiscussion(int n) {
        this.out.output(this.userOptions[n], 0);
        switch (this.questionCase) {
            case 1: {
                this.agp = this.gp;
                this.playingProponent = true;
                this.currentGame = -10;
                this.out.output(this.mesGen.getMessage(-2, this.currentGame, this.playingProponent, this.currentArg, this.previousArg), 1);
                break;
            }
            case 2: {
                if (n == 1) {
                    this.agp = this.pp;
                    this.playingProponent = true;
                    this.currentGame = -11;
                    this.out.output(this.mesGen.getMessage(-2, this.currentGame, this.playingProponent, this.currentArg, this.previousArg), 1);
                    break;
                }
                if (n != 2) break;
                this.previousArg = this.currentArg;
                this.currentArg = this.gAnswer;
                this.agp = this.gp;
                this.playingProponent = false;
                this.currentGame = -10;
                this.out.output(this.mesGen.getMessage(-2, this.currentGame, this.playingProponent, this.currentArg, this.previousArg), 1);
                break;
            }
            case 3: {
                this.previousArg = this.currentArg;
                this.currentArg = this.pAnswer;
                this.agp = this.pp;
                this.playingProponent = false;
                this.currentGame = -11;
                this.out.output(this.mesGen.getMessage(-2, this.currentGame, this.playingProponent, this.currentArg, this.previousArg), 1);
            }
        }
        this.userOptions = this.generateOptions(this.currentArg);
        return this.userOptions;
    }

    public String[] discuss(int n) {
        if (this.optionsMap[n] == this.def.length) {
            this.out.output(this.mesGen.getMessage(-9), 0);
            this.out.output("game over!", 2);
            return null;
        }
        this.out.output(this.mesGen.getMessage(-13, this.currentGame, !this.playingProponent, this.optionsMap[n], this.currentArg), 0);
        int n2 = this.agp.argue(this.optionsMap[n]);
        if (n2 == -1) {
            if (!this.agp.hasNext()) {
                this.gameOver();
                return null;
            }
            this.wrongMove();
            return this.userOptions;
        }
        this.previousArg = this.currentArg;
        this.currentArg = n2;
        this.out.output(this.mesGen.getMessage(-13, this.currentGame, this.playingProponent, this.currentArg, this.previousArg), 1);
        this.userOptions = this.generateOptions(this.currentArg);
        return this.userOptions;
    }

    private void gameOver() {
        this.out.output(this.mesGen.getMessage(-4, this.currentGame, this.playingProponent), 1);
        this.out.output("game over", 2);
    }

    private void wrongMove() {
        this.out.output(this.mesGen.getMessage(-3, this.currentGame, this.playingProponent), 1);
    }

    private String[] generateOptions(int n) {
        int n2 = 1;
        for (int i = 0; i < this.def.length; ++i) {
            if (!this.def[i][n]) continue;
            ++n2;
        }
        String[] stringArray = new String[n2];
        this.optionsMap = new int[n2];
        int n3 = 0;
        for (int i = 0; i < this.def.length; ++i) {
            if (!this.def[i][n]) continue;
            this.optionsMap[n3] = i;
            stringArray[n3] = this.mesGen.getMessage(-13, this.currentGame, !this.playingProponent, i, n);
            ++n3;
        }
        this.optionsMap[n3] = this.def.length;
        stringArray[n3] = this.mesGen.getMessage(-9);
        return stringArray;
    }

    public String getGameExplanationMessage() {
        String string = "";
        if (this.agp == this.gp) {
            string = this.playingProponent ? "The questioned argument was in the grounded extension\nof the framework.\nThe user has asserted that the argument was not really\ngrounded, so a grounded game has started, in which the\nuser plays the role of the opponent." : "The questioned argument wasn't in the grounded extension\nof the framework, thought it was in a preferred extension.\nThe user has asserted that the argument IS actually grounded,\nso a grounded game has started, in which the user plays\nthe role of the proponent.";
        } else if (this.agp == this.pp) {
            string = this.playingProponent ? "The questioned argument was in the a preferred extension\nof the framework.\nThe user has asserted that the argument wasn't really in\nsuch an extension, so a preferred game has started, in which\nthe user plays the role of the opponent." : "The questioned argument wasn't in neither the grounded or\na preferred extension of the framework.\nThe user has asserted that the argument was at least in a\npreferred extension, so a preferred game has started, in\nwhich the user plays the role of the proponent.";
        }
        return string;
    }
}

