/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class DiscussionGameLayout
extends DiscussionGameOutput
implements ActionListener {
    private DiscussionGameHandler dgh;
    String output = "";
    boolean playing;
    private JFrame frame;
    private JFrame argumentsFrame;
    private ExtensionLayout extensionsFrame;
    private JFrame helpFrame;
    private JMenuBar menuBar;
    private JMenu fwMenu;
    private JMenuItem menuLoad;
    private JMenuItem menuReload;
    private JMenuItem menuSwitch;
    private JMenuItem menuExit;
    private JMenu extMenu;
    private JMenuItem menuExts;
    private JMenu hlpMenu;
    private JMenuItem menuWHap;
    private JMenuItem menuHelp;
    private JMenuItem menuAbout;
    private JFileChooser fc;
    private JEditorPane outputView;
    JList argList;
    JButton selectButton;

    public DiscussionGameLayout(DiscussionGameHandler discussionGameHandler) {
        this.dgh = discussionGameHandler;
        this.frame = new JFrame("Discussion Game");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setLocation(200, 200);
        this.frame.setJMenuBar(this.createMenuBar());
        this.frame.setContentPane(this.createContentPane());
        this.frame.setSize(700, 500);
        this.frame.setVisible(true);
        this.fc = new JFileChooser();
        this.fc.setCurrentDirectory(new File(System.getProperty("user.dir")));
        this.argumentsFrame = new JFrame("Arguments & Input Manager");
        this.argumentsFrame.setDefaultCloseOperation(0);
        this.argumentsFrame.setVisible(false);
        this.argumentsFrame.setSize(300, 200);
        this.argumentsFrame.setContentPane(this.createArgContentPane());
        this.argumentsFrame.setLocation(this.frame.getLocation().x + 600, this.frame.getLocation().y + 300);
        this.extensionsFrame = new ExtensionLayout("Extensions Manager", this.dgh);
        this.extensionsFrame.setDefaultCloseOperation(1);
        this.extensionsFrame.setVisible(false);
        this.extensionsFrame.setSize(400, 300);
        this.extensionsFrame.setLocation(this.frame.getLocation().x + 600, this.frame.getLocation().y);
        this.helpFrame = new JFrame("Help");
        this.helpFrame.setDefaultCloseOperation(1);
        this.helpFrame.setVisible(false);
        this.helpFrame.setSize(500, 500);
        this.helpFrame.setContentPane(this.createHelpContentPane());
        this.helpFrame.setLocation(this.frame.getLocation().x + 600, this.frame.getLocation().y - 50);
    }

    public static void main(String[] stringArray) {
        DiscussionGameHandler discussionGameHandler = new DiscussionGameHandler();
        DefaultMessageGenerator defaultMessageGenerator = new DefaultMessageGenerator(discussionGameHandler.getArgs());
        discussionGameHandler.setMessageGenerator(defaultMessageGenerator);
        DiscussionGameLayout discussionGameLayout = new DiscussionGameLayout(discussionGameHandler);
        discussionGameHandler.setOutput(discussionGameLayout);
    }

    public JPanel createContentPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(true);
        this.outputView = this.createEditorPane();
        JScrollPane jScrollPane = new JScrollPane(this.outputView);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JEditorPane createEditorPane() {
        String string = "<HTML><BODY style=\"background-color:#ffffff\";><CENTER><BR><BR><P style=\"background-color:#feffb8;font:verdana;font-weight:bold\">University of Luxembourg</P><P style=\"background-color:#eeeeee;font:verdana;font-size:20\">Argumentation game player</P><P style=\"background-color:#feffb8;font:verdana\">12/01/2009</P></CENTER></BODY></HTML>";
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText(string);
        return jEditorPane;
    }

    private JMenuBar createMenuBar() {
        this.menuBar = new JMenuBar();
        this.fwMenu = new JMenu("File");
        this.fwMenu.setMnemonic(70);
        this.menuBar.add(this.fwMenu);
        this.menuLoad = new JMenuItem("Load framework...", 76);
        this.menuLoad.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.menuLoad.addActionListener(this);
        this.fwMenu.add(this.menuLoad);
        this.menuReload = new JMenuItem("Reload framework", 82);
        this.menuReload.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.menuReload.addActionListener(this);
        this.menuReload.setEnabled(false);
        this.fwMenu.add(this.menuReload);
        this.menuSwitch = new JMenuItem("Switch language generation...", 76);
        this.menuSwitch.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.menuSwitch.addActionListener(this);
        this.menuSwitch.setEnabled(true);
        this.fwMenu.add(this.menuSwitch);
        this.menuExit = new JMenuItem("Exit", 69);
        this.menuExit.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        this.menuExit.addActionListener(this);
        this.fwMenu.add(this.menuExit);
        this.extMenu = new JMenu("Extensions");
        this.extMenu.setMnemonic(69);
        this.menuBar.add(this.extMenu);
        this.menuExts = new JMenuItem("Show extensions...", 71);
        this.menuExts.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.menuExts.addActionListener(this);
        this.menuExts.setEnabled(false);
        this.extMenu.add(this.menuExts);
        this.hlpMenu = new JMenu("Help");
        this.hlpMenu.setMnemonic(76);
        this.menuBar.add(this.hlpMenu);
        this.menuWHap = new JMenuItem("What's happening??", 87);
        this.menuWHap.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.menuWHap.addActionListener(this);
        this.menuWHap.setEnabled(false);
        this.hlpMenu.add(this.menuWHap);
        this.menuHelp = new JMenuItem("Help...", 72);
        this.menuHelp.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.menuHelp.addActionListener(this);
        this.hlpMenu.add(this.menuHelp);
        this.menuAbout = new JMenuItem("About", 65);
        this.menuAbout.addActionListener(this);
        this.hlpMenu.add(this.menuAbout);
        return this.menuBar;
    }

    private JPanel createArgContentPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(true);
        this.argList = new JList();
        this.argList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.argList);
        this.selectButton = new JButton("Question");
        this.selectButton.addActionListener(this);
        this.selectButton.setEnabled(false);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.selectButton, "South");
        return jPanel;
    }

    private JPanel createHelpContentPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(true);
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText("<html><head><title>An Implementation of Argument Based Discussion</title> </head> <body lang=IT style='tab-interval:35.4pt'> <div class=Section1><pre><span lang=EN-GB style='font-size:14.0pt;font-family: Verdana;mso-ansi-language:EN-GB'><BR><BOLD>An Implementation of Argument Based Discussion</BOLD></span></pre> <p class=MsoNormal><span lang=EN-GB style='font-family:Verdana;mso-ansi-language: EN-GB'><o:p>&nbsp;</o:p></span></p> <p class=MsoNormal><span lang=EN-GB style='font-family:Verdana;mso-ansi-language: EN-GB'>Those are very basic instruction for the use of the program.<o:p></o:p></span></p> <p class=MsoNormal><span lang=EN-GB style='font-family:Verdana;mso-ansi-language: EN-GB'>In order to start a game:<o:p></o:p></span></p> <ol style='margin-top:0cm' start=1 type=1> <li class=MsoNormal style='mso-list:l0 level1 lfo1;tab-stops:list 36.0pt'><span class=GramE><span lang=EN-GB style='font-family:Verdana;mso-ansi-language: EN-GB'>open</span></span><span lang=EN-GB style='font-family:Verdana; mso-ansi-language:EN-GB'> an argumentation framework. You can find a couple of examples in the program folder. In order to load one, just use the menu File </span><span lang=EN-US style='font-family:Wingdings; mso-ascii-font-family:Verdana;mso-hansi-font-family:Verdana;mso-ansi-language: EN-US;mso-char-type:symbol;mso-symbol-font-family:Wingdings'><span style='mso-char-type:symbol;mso-symbol-font-family:Wingdings'>--></span></span><span lang=EN-US style='font-family:Verdana;mso-ansi-language:EN-US'> </span><span lang=EN-GB style='font-family:Verdana;mso-ansi-language:EN-GB'>Load and browse for the correct file;<o:p></o:p></span></li> <li class=MsoNormal style='mso-list:l0 level1 lfo1;tab-stops:list 36.0pt'><span class=GramE><span lang=EN-GB style='font-family:Verdana;mso-ansi-language: EN-GB'>once</span></span><span lang=EN-GB style='font-family:Verdana; mso-ansi-language:EN-GB'> loaded a framework, you should see the list of arguments of the framework in the <span class=SpellE>Arguments&amp;Input</span> frame. Choose an argument and question it;<o:p></o:p></span></li> <li class=MsoNormal style='mso-list:l0 level1 lfo1;tab-stops:list 36.0pt'><span class=GramE><span lang=EN-GB style='font-family:Verdana;mso-ansi-language: EN-GB'>once</span></span><span lang=EN-GB style='font-family:Verdana; mso-ansi-language:EN-GB'> questioned an argument, you can choose whether accept the application\u2019s opinion or discuss it. If you start discussing, you can choose next argument to use in the discussion from the <span class=SpellE>Arguments&amp;Input</span> frame, selecting it and pressing the \u2018Discuss\u2019 button;<o:p></o:p></span></li> <li class=MsoNormal style='mso-list:l0 level1 lfo1;tab-stops:list 36.0pt'><span lang=EN-GB style='font-family:Verdana;mso-ansi-language:EN-GB'>if you need to view the loaded framework or its extensions, just use the menu \u2018Framework\u2019 or \u2018Extensions\u2019;<o:p></o:p></span></li> <li class=MsoNormal style='mso-list:l0 level1 lfo1;tab-stops:list 36.0pt'><span class=GramE><span lang=EN-GB style='font-family:Verdana;mso-ansi-language: EN-GB'>the</span></span><span lang=EN-GB style='font-family:Verdana; mso-ansi-language:EN-GB'> menu \u2018Help\u2019 offers this introduction and the \u2018What\u2019s happening?\u2019 dialogue, which explains, during a game, what type of game is going on and why.<o:p></o:p></span></li> </ol> </div> </body> </html>");
        jPanel.add(new JScrollPane(jEditorPane));
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.menuLoad) {
            this.loadFramework();
        } else if (object == this.menuReload) {
            this.reloadFramework();
        } else if (object == this.menuSwitch) {
            this.switchMessageGenerator();
        } else if (object == this.menuExit) {
            System.exit(0);
        } else if (object == this.menuExts) {
            this.showExtensions();
        } else if (object == this.menuWHap) {
            this.showWhatHappens();
        } else if (object == this.menuHelp) {
            this.showHelp();
        } else if (object == this.menuAbout) {
            this.showAbout();
        } else if (object == this.selectButton) {
            if (this.playing) {
                String[] stringArray = this.dgh.discuss(this.argList.getLeadSelectionIndex());
                if (stringArray == null) {
                    this.selectButton.setText("Question");
                    this.updateArgList(this.dgh.getMessageGenerator().getArgs());
                    this.playing = false;
                    this.menuWHap.setEnabled(false);
                } else {
                    this.updateArgList(stringArray);
                }
            } else {
                Object[] objectArray = this.dgh.question(this.argList.getLeadSelectionIndex());
                int n = JOptionPane.showOptionDialog(this.frame, "What do you think?", "We can discuss...", 0, 3, null, objectArray, objectArray[1]);
                if (n != 0) {
                    this.selectButton.setText("Discuss");
                    String[] stringArray = this.dgh.startDiscussion(n);
                    this.updateArgList(stringArray);
                    this.playing = true;
                    this.menuWHap.setEnabled(true);
                }
            }
        }
    }

    private void loadFramework() {
        int n = this.fc.showOpenDialog(null);
        if (n == 0) {
            this.reloadFramework();
        }
    }

    private void reloadFramework() {
        block2: {
            File file = this.fc.getSelectedFile();
            try {
                this.dgh.load(file.getPath());
                this.updateArgList(this.dgh.getMessageGenerator().getArgs());
                this.extensionsFrame.updateContent();
                this.menuReload.setEnabled(true);
                this.menuExts.setEnabled(true);
                this.argumentsFrame.setVisible(true);
                this.outputView.setText("");
                this.selectButton.setEnabled(true);
                this.selectButton.setText("Question");
                this.playing = false;
            }
            catch (RuntimeException runtimeException) {
                System.out.println(runtimeException);
                Object[] objectArray = new Object[]{"Ok", "More..."};
                int n = JOptionPane.showOptionDialog(this.frame, "The selected file is not correctly formatted.", "File loading error", 0, 0, null, objectArray, objectArray[1]);
                if (n != 1) break block2;
                JOptionPane.showMessageDialog(this.frame, runtimeException.getMessage(), "File loading error details", 2);
            }
        }
    }

    private void switchMessageGenerator() {
        int n = JOptionPane.showConfirmDialog(this.frame, "Do you want to change language generation mode?", "Language Generation", 0);
        if (n == 1) {
            return;
        }
        if (this.dgh.getMessageGenerator() instanceof DefaultMessageGenerator) {
            this.dgh.setMessageGenerator(new NaturalLanguageMessageGenerator(this.dgh.getArgs()));
        } else {
            this.dgh.setMessageGenerator(new DefaultMessageGenerator(this.dgh.getArgs()));
        }
        this.reloadFramework();
    }

    private void showWhatHappens() {
        JOptionPane.showMessageDialog(this.frame, this.dgh.getGameExplanationMessage(), "What's happening?", 1);
    }

    private void showHelp() {
        this.helpFrame.setVisible(true);
    }

    private void showAbout() {
        String string = "Implementation of Argument Based Discussion\n\nAuthors:\n\tPatrizio Barbini (patrizio.barbini@uni.lu),\n\tYining Wu (yining.wu@uni.lu)\n\n";
        JOptionPane.showMessageDialog(this.frame, string, "About this program...", 1);
    }

    private void showExtensions() {
        if (!this.extensionsFrame.isVisible()) {
            this.extensionsFrame.setVisible(true);
        }
    }

    private void updateArgList(String[] stringArray) {
        this.argList.setListData(stringArray);
        this.argList.setSelectedIndex(0);
    }

    @Override
    public void output(String string, int n) {
        String string2 = "";
        if (n == 1) {
            string2 = "<P style=\"background-color:#eeeeee;font-weight:bold\">Computer says:</P><P style=\"font-family:verdana\">" + string + "</P>";
        } else if (n == 0) {
            string2 = "<P style=\"background-color:#feffb8;font-weight:bold\">User says:</P><P style=\"font-family:verdana\">" + string + "</P>";
        } else if (n == 2) {
            string2 = "<P style=\"background-color:#ff0000;font-weight:bold\">" + string + "</P>";
        }
        this.output = this.output + string2;
        this.outputView.setText(this.output);
    }
}

