/*
 * Decompiled with CFR 0.152.
 */
import argumentation.ArgumentationFramework;
import argumentation.Extension;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class ExtensionLayout
extends JFrame
implements ActionListener {
    private DiscussionGameHandler dgh;
    private ArgumentationFramework em;
    private JTabbedPane tabbedPane;
    private JTextArea groundedExtList;
    private JTextArea[] extList;
    private Extension groundedExtension;
    private Extension[][] extensions;
    private String[] arguments;
    private JLabel[] statusLabel;
    private int[] currentSel;

    public ExtensionLayout(String string, DiscussionGameHandler discussionGameHandler) {
        super(string);
        this.dgh = discussionGameHandler;
        this.add(this.createExtContentPanel());
    }

    private JPanel createExtContentPanel() {
        this.extList = new JTextArea[3];
        this.extensions = new Extension[3][];
        this.statusLabel = new JLabel[3];
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(true);
        this.tabbedPane = new JTabbedPane();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.groundedExtList = new JTextArea();
        this.groundedExtList.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.groundedExtList);
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.extList[0] = new JTextArea();
        this.extList[0].setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this.extList[0]);
        jPanel3.add((Component)jScrollPane2, "Center");
        this.statusLabel[0] = new JLabel("");
        jPanel3.add((Component)this.statusLabel[0], "North");
        jPanel3.add((Component)this.createButtonPanel(), "South");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.extList[1] = new JTextArea();
        this.extList[1].setEditable(false);
        JScrollPane jScrollPane3 = new JScrollPane(this.extList[1]);
        jPanel4.add((Component)jScrollPane3, "Center");
        this.statusLabel[1] = new JLabel("");
        jPanel4.add((Component)this.statusLabel[1], "North");
        jPanel4.add((Component)this.createButtonPanel(), "South");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        this.extList[2] = new JTextArea();
        this.extList[2].setEditable(false);
        JScrollPane jScrollPane4 = new JScrollPane(this.extList[2]);
        jPanel5.add((Component)jScrollPane4, "Center");
        this.statusLabel[2] = new JLabel("");
        jPanel5.add((Component)this.statusLabel[2], "North");
        jPanel5.add((Component)this.createButtonPanel(), "South");
        this.tabbedPane.addTab("Grounded", jPanel2);
        this.tabbedPane.addTab("Preferred", jPanel3);
        this.tabbedPane.addTab("Semi-stable", jPanel4);
        this.tabbedPane.addTab("Stable", jPanel5);
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.setMnemonicAt(1, 50);
        this.tabbedPane.setMnemonicAt(2, 51);
        this.tabbedPane.setMnemonicAt(3, 52);
        jPanel.add(this.tabbedPane);
        this.tabbedPane.setTabLayoutPolicy(1);
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        JButton jButton = new JButton("Previous");
        JButton jButton2 = new JButton("Next");
        jButton.setActionCommand("PREV");
        jButton2.setActionCommand("NEXT");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    public void updateContent() {
        this.em = this.dgh.getExtensionManager();
        this.arguments = this.dgh.getMessageGenerator().getArgs();
        Extension extension = this.em.getGroundedExtension();
        this.extensions = new Extension[3][];
        this.extensions[0] = this.em.getPreferredExtensions();
        this.extensions[1] = this.em.getSemiStableExtensions();
        this.extensions[2] = this.em.getStableExtensions();
        this.statusLabel[0].setText("Found " + this.extensions[0].length + " preferred extensions.");
        this.statusLabel[1].setText("Found " + this.extensions[1].length + " semi-stable extensions.");
        this.statusLabel[2].setText("Found " + this.extensions[2].length + " stable extensions.");
        this.currentSel = new int[3];
        this.groundedExtList.setText(this.extensionToText(extension));
        this.extList[0].setText(this.extensionToText(this.extensions[1][this.currentSel[0]]));
        this.extList[1].setText(this.extensionToText(this.extensions[1][this.currentSel[1]]));
        if (this.extensions[2].length == 0) {
            this.tabbedPane.setEnabledAt(3, false);
        } else {
            this.tabbedPane.setEnabledAt(3, true);
            this.extList[2].setText(this.extensionToText(this.extensions[2][this.currentSel[2]]));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        int n = this.tabbedPane.getSelectedIndex() - 1;
        if (jButton.getActionCommand().equals("NEXT")) {
            this.extList[n].setText(this.extensionToText(this.extensions[n][this.nextSelection(n)]));
        } else {
            this.extList[n].setText(this.extensionToText(this.extensions[n][this.previousSelection(n)]));
        }
    }

    private int nextSelection(int n) {
        int n2 = this.extensions[n].length;
        this.currentSel[n] = (this.currentSel[n] + 1) % n2;
        return this.currentSel[n];
    }

    private int previousSelection(int n) {
        int n2 = this.extensions[n].length;
        this.currentSel[n] = (this.currentSel[n] - 1 + n2) % n2;
        return this.currentSel[n];
    }

    private String extensionToText(Extension extension) {
        String string = "";
        for (int i = 0; i < extension.args.length; ++i) {
            if (!extension.args[i]) continue;
            string = string + this.arguments[i] + "\n";
        }
        return string;
    }
}

