/*
 * Decompiled with CFR 0.152.
 */
package argumentation;

import argumentation.Extension;
import argumentation.Labelling;
import argumentation.LabellingSet;
import java.util.Iterator;

public class ArgumentationFramework {
    private boolean[][] def;
    private LabellingSet potentialSemiStable;
    private LabellingSet potentialStable;
    private LabellingSet potentialPreferred;

    public ArgumentationFramework(boolean[][] blArray) {
        this.def = blArray;
        this.potentialSemiStable = new LabellingSet();
        this.potentialStable = new LabellingSet();
        this.potentialPreferred = new LabellingSet();
    }

    public boolean[][] getDef() {
        return this.def;
    }

    public Extension getGroundedExtension() {
        boolean[] blArray = new boolean[this.def.length];
        boolean[] blArray2 = this.defendedBy(blArray);
        while (!this.equals(blArray, blArray2)) {
            blArray = this.merge(blArray, blArray2);
            blArray2 = this.defendedBy(blArray2);
        }
        return new Extension(blArray);
    }

    public Extension[] getPreferredExtensions() {
        this.findPreferred(Labelling.allINLabelling(this.def.length));
        return this.labellingSetToExtensions(this.potentialPreferred);
    }

    public Extension[] getStableExtensions() {
        this.findStable(Labelling.allINLabelling(this.def.length));
        return this.labellingSetToExtensions(this.potentialStable);
    }

    public Extension[] getSemiStableExtensions() {
        this.findSemiStable(Labelling.allINLabelling(this.def.length));
        return this.labellingSetToExtensions(this.potentialSemiStable);
    }

    private void findSemiStable(Labelling labelling) {
        Iterator iterator = this.potentialSemiStable.iterator();
        while (iterator.hasNext()) {
            if (!labelling.isSuperset((Labelling)iterator.next(), 2)) continue;
            return;
        }
        if (!this.hasIllegallyIn(labelling)) {
            iterator = this.potentialSemiStable.iterator();
            while (iterator.hasNext()) {
                if (!((Labelling)iterator.next()).isSuperset(labelling, 2)) continue;
                iterator.remove();
            }
            this.potentialSemiStable.add(labelling);
            return;
        }
        int n = this.getSuperIllegallyIn(labelling);
        if (n >= 0) {
            this.findSemiStable(this.transitionStep(n, labelling));
        } else {
            for (int i = 0; i < labelling.labels.length; ++i) {
                if (!this.isIllegallyIn(i, labelling)) continue;
                this.findSemiStable(this.transitionStep(i, labelling));
            }
        }
    }

    private void findPreferred(Labelling labelling) {
        Iterator iterator = this.potentialPreferred.iterator();
        while (iterator.hasNext()) {
            if (!((Labelling)iterator.next()).isSuperset(labelling, 1)) continue;
            return;
        }
        if (!this.hasIllegallyIn(labelling)) {
            iterator = this.potentialPreferred.iterator();
            while (iterator.hasNext()) {
                if (!labelling.isSuperset((Labelling)iterator.next(), 1)) continue;
                iterator.remove();
            }
            this.potentialPreferred.add(labelling);
            return;
        }
        int n = this.getSuperIllegallyIn(labelling);
        if (n >= 0) {
            this.findPreferred(this.transitionStep(n, labelling));
        } else {
            for (int i = 0; i < labelling.labels.length; ++i) {
                if (!this.isIllegallyIn(i, labelling)) continue;
                this.findPreferred(this.transitionStep(i, labelling));
            }
        }
    }

    private void findStable(Labelling labelling) {
        Iterator iterator = this.potentialStable.iterator();
        if (labelling.contains(2)) {
            return;
        }
        if (!this.hasIllegallyIn(labelling)) {
            this.potentialStable.add(labelling);
            return;
        }
        int n = this.getSuperIllegallyIn(labelling);
        if (n >= 0) {
            this.findStable(this.transitionStep(n, labelling));
        } else {
            for (int i = 0; i < labelling.labels.length; ++i) {
                if (!this.isIllegallyIn(i, labelling)) continue;
                this.findStable(this.transitionStep(i, labelling));
            }
        }
    }

    private Labelling transitionStep(int n, Labelling labelling) {
        Labelling labelling2 = labelling.clone();
        labelling2.labels[n] = 0;
        if (this.isIllegallyOut(n, labelling2)) {
            labelling2.labels[n] = 2;
        }
        for (int i = 0; i < this.def.length; ++i) {
            if (!this.def[n][i] || !this.isIllegallyOut(i, labelling2)) continue;
            labelling2.labels[i] = 2;
        }
        return labelling2;
    }

    private boolean hasIllegallyIn(Labelling labelling) {
        for (int i = 0; i < labelling.labels.length; ++i) {
            if (!this.isIllegallyIn(i, labelling)) continue;
            return true;
        }
        return false;
    }

    private int getSuperIllegallyIn(Labelling labelling) {
        for (int i = 0; i < labelling.labels.length; ++i) {
            if (!this.isSuperIllegallyIn(i, labelling)) continue;
            return i;
        }
        return -1;
    }

    private boolean isIllegallyIn(int n, Labelling labelling) {
        if (labelling.labels.length != this.def.length) {
            throw new IllegalArgumentException("Non compatible labelling.");
        }
        if (labelling.labels[n] != 1) {
            return false;
        }
        for (int i = 0; i < labelling.labels.length; ++i) {
            if (!this.def[i][n] || labelling.labels[i] == 0) continue;
            return true;
        }
        return false;
    }

    private boolean isSuperIllegallyIn(int n, Labelling labelling) {
        if (labelling.labels.length != this.def.length) {
            throw new IllegalArgumentException("Non compatible labelling.");
        }
        if (labelling.labels[n] != 1) {
            return false;
        }
        for (int i = 0; i < labelling.labels.length; ++i) {
            if (!this.def[i][n] || labelling.labels[i] != 2 && (labelling.labels[i] != 1 || this.isIllegallyIn(i, labelling) || this.isSuperIllegallyIn(i, labelling))) continue;
            return true;
        }
        return false;
    }

    private boolean isIllegallyOut(int n, Labelling labelling) {
        if (labelling.labels.length != this.def.length) {
            throw new IllegalArgumentException("Non compatible labelling.");
        }
        if (labelling.labels[n] != 0) {
            return false;
        }
        for (int i = 0; i < labelling.labels.length; ++i) {
            if (!this.def[i][n] || labelling.labels[i] != 1) continue;
            return false;
        }
        return true;
    }

    private boolean isIllegallyUndec(int n, Labelling labelling) {
        if (labelling.labels.length != this.def.length) {
            throw new IllegalArgumentException("Non compatible labelling.");
        }
        if (labelling.labels[n] != 2) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < labelling.labels.length; ++i) {
            if (!this.def[i][n]) continue;
            if (labelling.labels[i] == 1) {
                return false;
            }
            if (labelling.labels[i] != 2) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isComplete(Labelling labelling) {
        if (labelling.labels.length != this.def.length) {
            throw new IllegalArgumentException("Non compatible labelling.");
        }
        for (int i = 0; i < labelling.labels.length; ++i) {
            if (!this.isIllegallyIn(i, labelling) && !this.isIllegallyOut(i, labelling) && !this.isIllegallyUndec(i, labelling)) continue;
            return false;
        }
        return true;
    }

    private boolean[] defendedBy(boolean[] blArray) {
        boolean[] blArray2 = this.defeatedBy(blArray);
        boolean[] blArray3 = new boolean[this.def.length];
        for (int i = 0; i < blArray.length; ++i) {
            boolean[] blArray4 = this.defeaters(i);
            if (!this.isIncluded(blArray4, blArray2)) continue;
            blArray3[i] = true;
        }
        return blArray3;
    }

    private boolean[] defeatedBy(boolean[] blArray) {
        boolean[] blArray2 = new boolean[this.def.length];
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            blArray2 = this.merge(blArray2, this.def[i]);
        }
        return blArray2;
    }

    private boolean[] defeaters(int n) {
        boolean[] blArray = new boolean[this.def.length];
        for (int i = 0; i < blArray.length; ++i) {
            if (!this.def[i][n]) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    private Extension labellingToExtension(Labelling labelling) {
        boolean[] blArray = new boolean[labelling.labels.length];
        for (int i = 0; i < labelling.labels.length; ++i) {
            if (labelling.labels[i] != 1) continue;
            blArray[i] = true;
        }
        return new Extension(blArray);
    }

    private Extension[] labellingSetToExtensions(LabellingSet labellingSet) {
        Iterator iterator = labellingSet.iterator();
        Extension[] extensionArray = new Extension[labellingSet.size()];
        int n = 0;
        while (iterator.hasNext()) {
            extensionArray[n] = this.labellingToExtension((Labelling)iterator.next());
            ++n;
        }
        return extensionArray;
    }

    private int[] booleanToLabelling(boolean[] blArray) {
        boolean[] blArray2 = this.defeatedBy(blArray);
        int[] nArray = new int[this.def.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = blArray[i] ? 1 : (blArray2[i] ? 0 : 2);
        }
        return nArray;
    }

    private boolean isIncluded(boolean[] blArray, boolean[] blArray2) {
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i] || blArray2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean[] merge(boolean[] blArray, boolean[] blArray2) {
        boolean[] blArray3 = new boolean[this.def.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray3[i] = blArray[i] || blArray2[i];
        }
        return blArray3;
    }

    private boolean equals(boolean[] blArray, boolean[] blArray2) {
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i] == blArray2[i]) continue;
            return false;
        }
        return true;
    }
}

