/*
 * Decompiled with CFR 0.152.
 */
package argumentation;

import argumentation.Labelling;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LabellingSet {
    private int argNum = 0;
    private Node root = new Node();

    public boolean add(Labelling labelling) {
        if (this.argNum == 0) {
            this.argNum = labelling.labels.length;
        } else if (labelling.labels.length != this.argNum) {
            throw new IllegalArgumentException("Illegally trying to add a " + labelling.labels.length + "-elements labelling to a " + this.argNum + "-elements labelling set!");
        }
        return this.add(this.root, labelling.labels, 0);
    }

    private boolean add(Node node, int[] nArray, int n) {
        if (n == this.argNum) {
            return false;
        }
        if (node.next[nArray[n]] == null) {
            node.next[nArray[n]] = new Node();
            this.add(node.next[nArray[n]], nArray, ++n);
        } else if (!this.add(node.next[nArray[n]], nArray, ++n)) {
            return false;
        }
        ++node.paths;
        return true;
    }

    public int size() {
        return this.root.paths;
    }

    public Iterator iterator() {
        return new LabellingSetIterator();
    }

    public Labelling[] toArray() {
        Labelling[] labellingArray = new Labelling[this.root.paths];
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            labellingArray[n] = (Labelling)iterator.next();
            ++n;
        }
        return labellingArray;
    }

    private class LabellingSetIterator
    implements Iterator {
        private boolean removeFlag;
        private boolean lookedAhead;
        private boolean isActive;
        private boolean newIterator;
        private Node[] backtrackNodes;
        private int[] currentLabelling;

        public LabellingSetIterator() {
            if (((LabellingSet)LabellingSet.this).root.paths == 0) {
                this.isActive = false;
            } else {
                this.removeFlag = false;
                this.isActive = true;
                this.lookedAhead = true;
                this.newIterator = true;
                this.currentLabelling = new int[LabellingSet.this.argNum];
                this.backtrackNodes = new Node[LabellingSet.this.argNum];
            }
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more labellings in the set.");
            }
            this.getNextLabelling();
            this.removeFlag = true;
            return new Labelling(this.currentLabelling);
        }

        @Override
        public boolean hasNext() {
            if (this.isActive && !this.lookedAhead) {
                this.isActive = this.lookForMore();
                this.lookedAhead = true;
            }
            return this.isActive;
        }

        private boolean lookForMore() {
            if (this.newIterator) {
                return true;
            }
            if (this.isActive) {
                for (int i = 0; i < this.backtrackNodes.length; ++i) {
                    for (int j = this.currentLabelling[i] + 1; j < 3; ++j) {
                        if (this.backtrackNodes[i].next[j] == null) continue;
                        return true;
                    }
                }
            }
            this.isActive = false;
            return false;
        }

        @Override
        public void remove() {
            if (!this.removeFlag) {
                throw new IllegalStateException("next() method not previously called.");
            }
            for (int i = this.backtrackNodes.length - 1; i >= 0; --i) {
                if (this.backtrackNodes[i].next[this.currentLabelling[i]].paths == 0) {
                    this.backtrackNodes[i].next[this.currentLabelling[i]] = null;
                }
                --this.backtrackNodes[i].paths;
            }
        }

        private void getNextLabelling() {
            if (this.newIterator) {
                this.buildNextLabelling(LabellingSet.this.root, 0);
                this.newIterator = false;
            } else {
                this.searchForNextLabelling(LabellingSet.this.argNum - 1);
            }
            this.lookedAhead = false;
        }

        private void searchForNextLabelling(int n) {
            int n2 = n;
            this.currentLabelling[n2] = this.currentLabelling[n2] + 1;
            while (this.currentLabelling[n] < 3) {
                if (this.backtrackNodes[n].next[this.currentLabelling[n]] != null) {
                    this.buildNextLabelling(this.backtrackNodes[n].next[this.currentLabelling[n]], n + 1);
                    return;
                }
                int n3 = n;
                this.currentLabelling[n3] = this.currentLabelling[n3] + 1;
            }
            this.searchForNextLabelling(n - 1);
        }

        private void buildNextLabelling(Node node, int n) {
            if (n == LabellingSet.this.argNum) {
                return;
            }
            for (int i = 0; i < 3; ++i) {
                if (node.next[i] == null) continue;
                this.currentLabelling[n] = i;
                this.backtrackNodes[n] = node;
                this.buildNextLabelling(node.next[i], n + 1);
                return;
            }
        }
    }

    private class Node {
        public int paths = 0;
        public Node[] next = new Node[3];
    }
}

