/*
 * Decompiled with CFR 0.152.
 */
package argumentation;

import argumentation.ArgumentationGamePlayer;

public class PreferredGamePlayer
implements ArgumentationGamePlayer {
    private static final int PROPONENT = 0;
    private static final int OPPONENT = 1;
    private int[][] playerChoices;
    private boolean started;
    private Node game;
    private int winner;
    boolean[][] def;

    public PreferredGamePlayer(boolean[][] blArray) {
        this.def = blArray;
    }

    @Override
    public void init() {
        this.playerChoices = new int[2][];
        this.playerChoices[0] = new int[this.def.length];
        this.playerChoices[1] = new int[this.def.length];
        this.started = false;
    }

    public int distance() {
        if (this.started) {
            return this.game.distance;
        }
        return -1;
    }

    @Override
    public boolean[] next() {
        boolean[] blArray = new boolean[this.game.next.length];
        for (int i = 0; i < this.game.next.length; ++i) {
            if (this.game.next[i] == null) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    @Override
    public boolean hasNext() {
        for (int i = 0; i < this.game.next.length; ++i) {
            if (this.game.next[i] == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public int argue(int n) {
        if (n < 0 || n >= this.def.length) {
            throw new IllegalArgumentException("Not a correct argument for the current framework.");
        }
        if (!this.started) {
            this.game = this.buildGame(n, new boolean[this.def.length], new boolean[this.def.length], 0);
            this.started = true;
            if (this.game.winner == 0) {
                return -2;
            }
        } else if (this.game.next[n] != null) {
            this.game = this.game.next[n];
        } else {
            return -1;
        }
        int n2 = -1;
        for (int i = 0; i < this.game.next.length; ++i) {
            if (this.game.next[i] == null || this.game.next[i].winner != this.game.winner || n2 != -1 && this.game.next[i].distance >= this.game.next[n2].distance) continue;
            n2 = i;
        }
        this.game = this.game.next[n2];
        return n2;
    }

    private Node buildGame(int n, boolean[] blArray, boolean[] blArray2, int n2) {
        boolean[] blArray3;
        boolean[] blArray4;
        Node node = new Node();
        node.winner = n2;
        if (n2 == 1 && blArray[n]) {
            node.distance = 0;
            return node;
        }
        int[] nArray = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
        if (n2 == 1) {
            blArray4 = this.update(blArray2, n);
            blArray3 = blArray;
        } else {
            blArray3 = this.update(blArray, n);
            blArray4 = blArray2;
        }
        boolean bl = false;
        for (int i = 0; i < this.def.length; ++i) {
            if (blArray2[i] || !this.def[i][n] && (n2 != 0 || !this.defeatsSome(i, blArray))) continue;
            bl = true;
            node.next[i] = this.buildGame(i, blArray3, blArray4, this.nextPlayer(n2));
            if (nArray[node.next[i].winner] > node.next[i].distance + 1) {
                nArray[node.next[i].winner] = node.next[i].distance + 1;
            }
            if (node.next[i].winner != this.nextPlayer(n2)) continue;
            node.winner = this.nextPlayer(n2);
        }
        node.distance = n2 == 1 && !bl ? 0 : nArray[node.winner];
        return node;
    }

    private int nextPlayer(int n) {
        if (n == 1) {
            return 0;
        }
        return 1;
    }

    private boolean defeatsSome(int n, boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i] || !this.def[n][i]) continue;
            return true;
        }
        return false;
    }

    private boolean[] update(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray2[i] = blArray[i];
        }
        blArray2[n] = true;
        return blArray2;
    }

    private boolean[] getDefeaters(int n) {
        boolean[] blArray = new boolean[this.def.length];
        for (int i = 0; i < blArray.length; ++i) {
            if (!this.def[i][n]) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    private class Node {
        public int winner;
        public int distance;
        public Node[] next;

        public Node() {
            this.next = new Node[PreferredGamePlayer.this.def.length];
        }
    }
}

