/*
 * Decompiled with CFR 0.152.
 */
package argumentation;

import argumentation.ArgumentationGamePlayer;

public class GroundedGamePlayer
implements ArgumentationGamePlayer {
    private final int PROPONENT = 0;
    private final int OPPONENT = 1;
    private int[][] playerChoices;
    private boolean started;
    private Node game;
    private int winner;
    boolean[][] def;

    public GroundedGamePlayer(boolean[][] blArray) {
        this.def = blArray;
    }

    @Override
    public void init() {
        this.playerChoices = new int[2][];
        this.playerChoices[0] = new int[this.def.length];
        this.playerChoices[1] = new int[this.def.length];
        this.started = false;
    }

    public int distance() {
        if (this.started) {
            return this.game.distance;
        }
        return -1;
    }

    @Override
    public boolean[] next() {
        boolean[] blArray = new boolean[this.game.next.length];
        for (int i = 0; i < this.game.next.length; ++i) {
            if (this.game.next[i] == null) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    @Override
    public boolean hasNext() {
        for (int i = 0; i < this.game.next.length; ++i) {
            if (this.game.next[i] == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public int argue(int n) {
        if (n < 0 || n >= this.def.length) {
            throw new IllegalArgumentException("Not a correct argument for the current framework.");
        }
        if (!this.started) {
            this.game = this.buildGame(n, new boolean[this.def.length], 0);
            this.started = true;
            if (this.game.winner == 0) {
                return -2;
            }
        } else if (this.game.next[n] != null) {
            this.game = this.game.next[n];
        } else {
            return -1;
        }
        int n2 = -1;
        for (int i = 0; i < this.game.next.length; ++i) {
            if (this.game.next[i] == null || this.game.next[i].winner != this.game.winner || n2 != -1 && this.game.next[i].distance >= this.game.next[n2].distance) continue;
            n2 = i;
        }
        this.game = this.game.next[n2];
        return n2;
    }

    private Node buildGame(int n, boolean[] blArray, int n2) {
        Node node = new Node();
        node.winner = n2;
        int[] nArray = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
        boolean[] blArray2 = n2 == 0 ? this.update(blArray, n) : blArray;
        boolean bl = false;
        for (int i = 0; i < this.def.length; ++i) {
            if (!this.def[i][n] || this.nextPlayer(n2) == 0 && blArray[i]) continue;
            bl = true;
            node.next[i] = this.buildGame(i, blArray2, this.nextPlayer(n2));
            if (nArray[node.next[i].winner] > node.next[i].distance + 1) {
                nArray[node.next[i].winner] = node.next[i].distance + 1;
            }
            if (node.next[i].winner != this.nextPlayer(n2)) continue;
            node.winner = this.nextPlayer(n2);
        }
        node.distance = !bl ? 0 : nArray[node.winner];
        return node;
    }

    private int nextPlayer(int n) {
        if (n == 1) {
            return 0;
        }
        return 1;
    }

    private boolean[] update(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray2[i] = blArray[i];
        }
        blArray2[n] = true;
        return blArray2;
    }

    private boolean[] getDefeaters(int n) {
        boolean[] blArray = new boolean[this.def.length];
        for (int i = 0; i < blArray.length; ++i) {
            if (!this.def[i][n]) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    private class Node {
        public int winner;
        public int distance;
        public Node[] next;

        public Node() {
            this.next = new Node[GroundedGamePlayer.this.def.length];
        }
    }
}

