/*
 * Decompiled with CFR 0.152.
 */
package argumentation;

public class Labelling {
    public static final int IN = 1;
    public static final int OUT = 0;
    public static final int UNDEC = 2;
    public int[] labels;

    public Labelling(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 2 && nArray[i] >= 0) continue;
            throw new IllegalArgumentException("The labels are not in {IN, OUT, UNDEC}");
        }
        this.labels = nArray;
    }

    public boolean equals(Labelling labelling) {
        if (labelling.labels.length != this.labels.length) {
            throw new IllegalArgumentException("Trying to compare two incompatible labellings.");
        }
        for (int i = 0; i < this.labels.length; ++i) {
            if (labelling.labels[i] == this.labels[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isSuperset(Labelling labelling, int n) {
        if (labelling.labels.length != this.labels.length) {
            throw new IllegalArgumentException("Trying to compare two incompatible labellings.");
        }
        boolean bl = false;
        for (int i = 0; i < this.labels.length; ++i) {
            if (this.labels[i] != n && labelling.labels[i] == n) {
                return false;
            }
            if (bl || this.labels[i] != n || labelling.labels[i] == n) continue;
            bl = true;
        }
        return bl;
    }

    public boolean contains(int n) {
        for (int i = 0; i < this.labels.length; ++i) {
            if (this.labels[i] != n) continue;
            return true;
        }
        return false;
    }

    public boolean[] getSubset(int n) {
        boolean[] blArray = new boolean[this.labels.length];
        for (int i = 0; i < this.labels.length; ++i) {
            if (this.labels[i] != n) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    public Labelling clone() {
        int[] nArray = new int[this.labels.length];
        for (int i = 0; i < this.labels.length; ++i) {
            nArray[i] = this.labels[i];
        }
        return new Labelling(nArray);
    }

    public static Labelling allINLabelling(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 1;
        }
        return new Labelling(nArray);
    }
}

